#delimit ;

cap log close ;
log using t2_pvalues_check.log , replace ;

clear ;
set more off ;

use t2_mcout_all ;

foreach type in webb rad { ;
foreach gg in 6 10 20 50 { ;
	quantile p_`type'_res if numstates == `gg' , 
		title(`type' G=`gg') name(g_`type'_`gg' , replace) ;
	summ p_`type'_res if numstates == `gg' , detail ;
} ;

graph combine g_`type'_6 g_`type'_10 g_`type'_20 g_`type'_50 ;
graph export quantiles_`type'.png , replace ;

} ;

foreach gg in 6 10 20 50 { ;
	qqplot p_webb_res p_rad_res if numstates == `gg' , 
		title(G=`gg') name(g_qq_`gg' , replace) ;
	graph twoway (scatter p_rad_res p_webb_res if numstates == `gg') 
		(line p_webb_res p_webb_res if numstates == `gg') ,
		title(G=`gg') name(g_sc_`gg' , replace) ;
} ;

graph combine g_qq_6 g_qq_10 g_qq_20 g_qq_50 ;
graph export qq_plot.png , replace ;

graph combine g_sc_6 g_sc_10 g_sc_20 g_sc_50 ;
graph export scatter_plot.png , replace ;

log close ;

